<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function userProfile()
    {
        return $this->hasOne('App\Models\UserProfile', 'user_id');
    }

    public function personalConsultatation()
    {
        return $this->hasOne('App\Models\PersonalConsultation', 'user_id');
    }

    public function role()
    {
        return $this->belongsTo('Role', 'role_id');
    }

}